/*
 * Decompiled with CFR 0.152.
 */
package pm.meh.emienchants;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import pm.meh.emienchants.CustomEmiSlotWidget;
import pm.meh.emienchants.EnchantmentEmiPlugin;
import pm.meh.emienchants.Util;

public class EnchantmentEmiRecipe
implements EmiRecipe {
    private static final class_2960 ICON_INFO = new class_2960("emienchants", "textures/gui/icon_info.png");
    private static final class_2960 ICON_ENCH_TABLE = new class_2960("emienchants", "textures/gui/icon_ench_table.png");
    private static final class_2960 ICON_VILLAGER = new class_2960("emienchants", "textures/gui/icon_villager.png");
    private static final class_2960 ICON_DISCOVERABLE = new class_2960("emienchants", "textures/gui/icon_discoverable.png");
    private static final class_2960 ICON_TREASURE = new class_2960("emienchants", "textures/gui/icon_treasure.png");
    private static final class_2960 ICON_CURSE = new class_2960("emienchants", "textures/gui/icon_curse.png");
    private static final int LAYOUT_X_OFFSET = 22;
    private static final int LAYOUT_X_OFFSET_SMALL = 2;
    private static final int LAYOUT_Y_OFFSET = 2;
    private static final int LAYOUT_ROW_HEIGHT = 10;
    private static final int LAYOUT_TEXT_COLOR = 0x333333;
    private static final boolean LAYOUT_TEXT_SHADOW = false;
    private final int LAYOUT_DESCRIPTION_OFFSET;
    private final class_2960 id;
    private final class_2960 enchantmentResourceLocation;
    private final class_1887 enchantment;
    private final List<EmiStack> inputs;
    private final EmiIngredient canApplyTo;
    private final EmiIngredient incompatibleSlot;
    private final List<IconBoolStatEntry> iconStats;
    private final List<class_5481> description;

    public EnchantmentEmiRecipe(class_2960 location, class_1887 enchantment) {
        this.enchantmentResourceLocation = location;
        this.enchantment = enchantment;
        this.id = new class_2960("emienchants", String.format("/%s/%s", location.method_12836(), location.method_12832()));
        this.inputs = IntStream.range(1, enchantment.method_8183() + 1).mapToObj(this::getBookForLevel).toList();
        this.canApplyTo = EmiIngredient.of(class_7923.field_41178.method_10220().map(class_1799::new).filter(arg_0 -> ((class_1887)enchantment).method_8192(arg_0)).map(EmiStack::of).toList());
        this.incompatibleSlot = EmiIngredient.of(class_7923.field_41176.method_29722().stream().filter(e -> !((class_1887)e.getValue()).equals(enchantment) && !enchantment.method_8188((class_1887)e.getValue())).map(e -> Util.getBookStackForLevel(((class_5321)e.getKey()).method_29177(), ((class_1887)e.getValue()).method_8183())).toList());
        this.iconStats = List.of(new IconBoolStatEntry(ICON_ENCH_TABLE, "ench_table", enchantment.method_25950() && !enchantment.method_8193(), true), new IconBoolStatEntry(ICON_VILLAGER, "tradeable", enchantment.method_25949(), true), new IconBoolStatEntry(ICON_DISCOVERABLE, "discoverable", enchantment.method_25950(), true), new IconBoolStatEntry(ICON_TREASURE, "treasure", enchantment.method_8193(), false), new IconBoolStatEntry(ICON_CURSE, "curse", enchantment.method_8195(), false));
        this.LAYOUT_DESCRIPTION_OFFSET = 2 + 10 * (this.incompatibleSlot.isEmpty() ? 5 : 6);
        String descriptionId = enchantment.method_8184() + ".desc";
        class_5250 descriptionTranslatable = class_2561.method_43471((String)descriptionId).method_27692(class_124.field_1056);
        this.description = descriptionTranslatable.getString().equals(descriptionId) ? List.of() : class_310.method_1551().field_1772.method_1728((class_5348)descriptionTranslatable, this.getDisplayWidth() - 4);
    }

    private EmiStack getBookForLevel(int level) {
        return Util.getBookStackForLevel(this.enchantmentResourceLocation, level);
    }

    public EmiRecipeCategory getCategory() {
        return EnchantmentEmiPlugin.ENCHANTS_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.canApplyTo, EmiIngredient.of(this.inputs));
    }

    public List<EmiStack> getOutputs() {
        return this.inputs;
    }

    public int getDisplayWidth() {
        return 160;
    }

    public int getDisplayHeight() {
        return this.LAYOUT_DESCRIPTION_OFFSET + 10 * this.description.size();
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        int row = 0;
        widgetHolder.addSlot((EmiIngredient)this.getBookForLevel(this.enchantment.method_8183()), 2, 2);
        widgetHolder.add((Widget)new CustomEmiSlotWidget(this.canApplyTo, 2, 22, false, (class_2561)class_2561.method_43471((String)"emienchants.property.applicable_to")));
        if (!this.incompatibleSlot.isEmpty()) {
            widgetHolder.add((Widget)new CustomEmiSlotWidget(this.incompatibleSlot, 2, 42, true, (class_2561)class_2561.method_43471((String)"emienchants.property.conflicts")));
        }
        class_5250 title = class_2561.method_43471((String)this.enchantment.method_8184());
        if (this.enchantment.method_8183() > 1) {
            title = title.method_27693(String.format(" \u00a75%d-%d", this.enchantment.method_8187(), this.enchantment.method_8183()));
        }
        widgetHolder.addText((class_2561)title, 22, 2 + 10 * row++, 0x333333, false);
        widgetHolder.addText((class_2561)class_2561.method_43470((String)this.enchantmentResourceLocation.method_12836()).method_27692(class_124.field_1058), 22, 2 + 10 * row++, 0x333333, false);
        widgetHolder.addText((class_2561)class_2561.method_43469((String)"emienchants.property.category", (Object[])new Object[]{Util.getLocalizedTextByCode(this.enchantment.field_9083.name(), "emienchants.property.category.%s").method_27692(class_124.field_1064)}), 22, 2 + 10 * row++, 0x333333, false);
        TextWidget rarityWidget = widgetHolder.addText((class_2561)class_2561.method_43469((String)"emienchants.property.rarity", (Object[])new Object[]{Util.getLocalizedTextByCode(this.enchantment.method_8186().name(), "emienchants.property.rarity.%s").method_27692(class_124.field_1064)}), 22, 2 + 10 * row, 0x333333, false);
        widgetHolder.addTexture(ICON_INFO, 22 + rarityWidget.getBounds().width() + 1, 2 + 10 * row, 7, 8, 7, 8, 7, 8, 7, 8);
        widgetHolder.addTooltipText(Stream.concat(Stream.of(class_2561.method_43469((String)"emienchants.property.rarity_weight", (Object[])new Object[]{this.enchantment.method_8186().method_8197()})), IntStream.range(1, this.enchantment.method_8183() + 1).mapToObj(lvl -> class_2561.method_43469((String)"emienchants.property.cost", (Object[])new Object[]{lvl, this.enchantment.method_8182(lvl), this.enchantment.method_20742(lvl)}))).toList(), 22, 2 + 10 * row++, rarityWidget.getBounds().width() + 9, 8);
        int iconSectionWidth = 0;
        int iconXOffset = 0;
        if (this.incompatibleSlot.isEmpty()) {
            iconSectionWidth = (this.getDisplayWidth() - 4) / this.iconStats.size();
            iconXOffset = 2;
        } else {
            iconSectionWidth = (this.getDisplayWidth() - 22 - 2) / 3;
            iconXOffset = 22;
        }
        int iconYOffset = 2 + 10 * row;
        int iconCounter = 0;
        for (IconBoolStatEntry stat : this.iconStats) {
            widgetHolder.addTexture(stat.icon, iconXOffset, iconYOffset, 8, 8, 8, 8, 8, 8, 8, 8);
            TextWidget statWidget = widgetHolder.addText(stat.getValueLabel(), iconXOffset + 10, iconYOffset, 0x333333, false);
            widgetHolder.addTooltipText(List.of(class_2561.method_43471((String)String.format("emienchants.property.%s.%s", stat.label, stat.value))), iconXOffset, iconYOffset, statWidget.getBounds().width() + 10, 8);
            if (!this.incompatibleSlot.isEmpty() && ++iconCounter == 3) {
                iconCounter = 0;
                iconXOffset = 22;
                iconYOffset += 10;
                continue;
            }
            iconXOffset += iconSectionWidth;
        }
        row = 0;
        for (class_5481 line : this.description) {
            widgetHolder.addText(line, 2, this.LAYOUT_DESCRIPTION_OFFSET + 10 * row++, 0x333333, false);
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    private record IconBoolStatEntry(class_2960 icon, String label, boolean value, boolean isPositive) {
        public class_2561 getValueLabel() {
            return class_2561.method_43471((String)("emienchants.property.value." + this.value)).method_27696(class_2583.field_24360.method_36139(this.value ^ this.isPositive ? 0xAA0000 : 34816));
        }
    }
}

